<?php

namespace Avodel\WebDriver\Components\CaptchaVerifier\Verifier;

use Avodel\WebDriver\Components\Frames\Frame;
use Avodel\WebDriver\WebDriver;
use RuntimeException;

final readonly class RecaptchaV2EnterpriseCaptchaVerifier implements CaptchaVerifierInterface
{
    public function verify(WebDriver $webDriver): void
    {
        throw new RuntimeException('Recaptcha V2 Enterprise prover is not implemented yet.');
    }

    public function isVerificationRequired(WebDriver $webDriver): bool
    {
        [$bFrame, $anchorFrame] = $this->getRecaptchaFrames($webDriver);

        return $bFrame && $anchorFrame;
    }

    /**
     * @return array<Frame|null>
     */
    private function getRecaptchaFrames(WebDriver $webDriver): array
    {
        $allFrames = $webDriver->getFramesHandler()->getFrames();
        $bFrame = null;
        $anchorFrame = null;

        foreach ($allFrames as $frame) {
            if (str_starts_with($frame->getSrc(), 'https://www.google.com/recaptcha/enterprise/anchor')) {
                $anchorFrame = $frame;
                continue;
            }

            if (str_starts_with($frame->getSrc(), 'https://www.google.com/recaptcha/enterprise/bframe')) {
                $bFrame = $frame;
            }
        }

        return [$bFrame, $anchorFrame];
    }
}
