<?php

namespace Avodel\WebDriver\Extension;

use Facebook\WebDriver\Chrome\ChromeDevToolsDriver;
use Facebook\WebDriver\Remote\RemoteWebDriver;

final readonly class TimezoneWebDriverExtension implements WebDriverExtensionInterface
{
    public function apply(RemoteWebDriver $webDriver): void
    {
        $devTools = new ChromeDevToolsDriver($webDriver);
        $devTools->execute('Emulation.setTimezoneOverride', [
            'timezoneId' => 'Europe/Warsaw',
        ]);
    }
}
