<?php

namespace Avodel\WebDriver\Components\CaptchaVerifier\Verifier;

use Avodel\WebDriver\Components\CaptchaVerifier\Exception\CaptchaVerificationFailedException;
use Avodel\WebDriver\Components\Frames\Frame;
use Avodel\WebDriver\WebDriver;

interface CaptchaVerifierInterface
{
    /**
     * @throws CaptchaVerificationFailedException
     *
     * @param array<Frame> $frames
     */
    public function verify(WebDriver $webDriver, array $frames): void;

    /**
     * @param array<Frame> $frames
     */
    public function isVerificationRequired(WebDriver $webDriver, array $frames): bool;
}
