<?php

namespace Avodel\WebDriver\Driver;

use Facebook\WebDriver\Chrome\ChromeDevToolsDriver;

final readonly class DevToolsDriver
{
    public function __construct(
        private ChromeDevToolsDriver $chromeDevToolsDriver,
    )
    {
    }

    public function setUserAgentOverride(string $userAgent): void
    {
        $data = [
            'userAgent' => $userAgent,
            'acceptLanguage' => 'en-US,en',
            'platform' => 'Linux x86_64',
            'userAgentMetadata' => [
                'brands' => [
                    [
                        'brand' => 'Not)A;Brand',
                        'version' => '99',
                    ],
                    [
                        'brand' => 'Google Chrome',
                        'version' => '127',
                    ],
                    [
                        'brand' => 'Chromium',
                        'version' => '127',
                    ],
                ],
                'platform' => 'Linux',
                'platformVersion' => '6.2.0',
                'architecture' => 'x86_64',
                'model' => 'Desktop',
                'mobile' => false,
            ],
        ];

        if (str_contains($userAgent, 'Linux')) {
            $data['platform'] = 'Linux x86_64';
            $data['userAgentMetadata']['platform'] = 'Linux';
            $data['userAgentMetadata']['architecture'] = 'x86_64';
            $data['userAgentMetadata']['platformVersion'] = '';
        }

        if (str_contains($userAgent, 'Windows')) {
            $data['platform'] = 'win32';
            $data['userAgentMetadata']['platform'] = 'Windows';
            preg_match('/Windows NT ([0-9.]+)/', $userAgent, $matches);
            $data['userAgentMetadata']['platformVersion'] = $matches[1] ?? '';
            $data['userAgentMetadata']['architecture'] = 'x64';
        }

        if (str_contains($userAgent, 'Macintosh') || str_contains($userAgent, 'Mac OS X')) {
            $data['platform'] = 'macOS';
            $data['userAgentMetadata']['platform'] = 'macOS';
            preg_match('/Mac OS X ([0-9_]+)/', $userAgent, $matches);
            $data['userAgentMetadata']['platformVersion'] = isset($matches[1]) ? str_replace('_', '.', $matches[1]) : '';
            $data['userAgentMetadata']['architecture'] = 'x86_64';
        }

        preg_match('/Chrome\/([\d]+)/', $userAgent, $chromeMatch);
        $chromeVersion = $chromeMatch[1] ?? '127';

        if ($chromeVersion) {
            $data['userAgentMetadata']['brands'] = [
                [
                    'brand' => 'Not)A;Brand',
                    'version' => '99',
                ],
                [
                    'brand' => 'Google Chrome',
                    'version' => $chromeVersion,
                ],
                [
                    'brand' => 'Chromium',
                    'version' => $chromeVersion,
                ],
            ];
        }

        $this->chromeDevToolsDriver->execute('Emulation.setUserAgentOverride', $data);
    }
}
