<?php

namespace Avodel\WebDriver\Components\CaptchaVerifier\Verifier;

use Avodel\WebDriver\Components\CaptchaVerifier\Solver\CloudflareTurnstileTokenSolverInterface;
use Avodel\WebDriver\WebDriver;
use Webmozart\Assert\Assert;

final readonly class CloudflareTurnstileVerifier implements CaptchaVerifierInterface
{
    public function __construct(
        private CloudflareTurnstileTokenSolverInterface $cloudflareTurnstileSolver,
    )
    {
    }

    public function verify(WebDriver $webDriver, array $frames): void
    {
        $siteKey = $webDriver->evaluateScript('window.turnstileSiteKey');
        $token = $this->cloudflareTurnstileSolver->getSolution($webDriver->getCurrentUrl(), $siteKey);

        $verificationJs = <<<JS
window.postMessage({
    type: "invokeTurnstileCallback",
    params: {publicKey: window.turnstileSiteKey, token: '$token'}
}, location.origin)
JS;

        $webDriver->executeScript($verificationJs);

        Assert::true($webDriver->evaluateScript('window.turnstileSolved'), 'Captcha was not solved.');
    }

    public function isVerificationRequired(WebDriver $webDriver, array $frames): bool
    {
        return $webDriver->evaluateScript('window.turnstileSiteKey !== undefined && window.turnstileSolved === false');
    }
}
