<?php

namespace Avodel\WebDriver\Driver;

final readonly class MouseConfig
{
    public function __construct(
        private int $movePauseMin,
        private int $movePauseMax,
        private int $beforeClickPauseMin,
        private int $beforeClickPauseMax,
        private int $moveDistanceDivisor,
    )
    {
    }

    public function getMovePauseMin(): int
    {
        return $this->movePauseMin;
    }

    public function getMovePauseMax(): int
    {
        return $this->movePauseMax;
    }

    public function getBeforeClickPauseMin(): int
    {
        return $this->beforeClickPauseMin;
    }

    public function getBeforeClickPauseMax(): int
    {
        return $this->beforeClickPauseMax;
    }

    public function getMoveDistanceDivisor(): int
    {
        return $this->moveDistanceDivisor;
    }
}
