(() => {
    Object.defineProperty(window, "navigator", {
        value: new Proxy(navigator, {
            has: (target, key) => (key === "vendor" ? true : key in target),
            get: (target, key) =>
                key === "vendor"
                    ? 'Google Inc.'
                    : typeof target[key] === "function"
                        ? target[key].bind(target)
                        : target[key],
        }),
    });
})();
