<?php

namespace Avodel\WebDriver\Driver;

use Avodel\ProxyHandler\ProxyHandlerInterface;
use Avodel\WebDriver\Extension\AjaxOverriderWebDriverExtension;
use Avodel\WebDriver\Extension\CloudflareTurnstileWebDriverExtension;
use Avodel\WebDriver\Extension\InitFingerprintWebDriverExtension;
use Avodel\WebDriver\Profile\ProfileManagerInterface;
use Avodel\WebDriver\UserData\UserDataManager;

final readonly class MinkPhpWebDriverFactory
{
    public function __construct(
        private string $wdHost,
        private ?string $proxyUrl,
        /**
         * @var @var array{script?: int, implicit?: int, page_load?: int}
         */
        private array $timeouts,
        private UserDataManager $userDataManager,
        private string $mouseMovementMode,
        private ?string $userDataDirectory,
        private ProfileManagerInterface $profileManager,
        private ProxyHandlerInterface $proxyHandler,
    )
    {
    }

    public function create(): MinkPhpWebDriver
    {
        return new MinkPhpWebDriver(
            $this->wdHost,
            [
                new InitFingerprintWebDriverExtension(),
                new AjaxOverriderWebDriverExtension(),
                new CloudflareTurnstileWebDriverExtension(),
            ],
            $this->proxyUrl,
            $this->timeouts,
            $this->mouseMovementMode,
            $this->userDataManager,
            $this->userDataDirectory,
            $this->profileManager,
            $this->proxyHandler,
        );
    }
}
