<?php

namespace Avodel\WebDriver\Driver;

use Avodel\WebDriver\Components\Ajax\AjaxHandlerFactory;
use Avodel\WebDriver\Components\CaptchaVerifier\Verifier\CaptchaVerifierFactory;
use Avodel\WebDriver\Components\Debug\DebuggerFactory;
use Avodel\WebDriver\Components\Frames\FramesHandlerFactory;
use Behat\Mink\Session;

final readonly class WebDriverFactory
{
    public function __construct(
        private MinkPhpWebDriverFactory $minkPhpWebDriverFactory,
        private AjaxHandlerFactory $ajaxHandlerFactory,
        private CaptchaVerifierFactory $captchaVerifierFactory,
        private FramesHandlerFactory $framesHandlerFactory,
        private DebuggerFactory $debuggerFactory,
    )
    {
    }

    public function create(): WebDriver
    {
        $minkPhpWebDriver = $this->minkPhpWebDriverFactory->create();
        $session = new Session($minkPhpWebDriver);

        $ajaxHandler = $this->ajaxHandlerFactory->create($session);
        $framesHandler = $this->framesHandlerFactory->create($session);
        $debugger = $this->debuggerFactory->create($session, $framesHandler, $ajaxHandler);
        $captchaVerifier = $this->captchaVerifierFactory->create($session, $framesHandler, $ajaxHandler);

        return new WebDriver(
            $session,
            $ajaxHandler,
            $captchaVerifier,
            $framesHandler,
            $debugger,
        );
    }
}
