<?php

namespace Avodel\WebDriver\Profile;


final class ProfileBuilder
{
    private ?string $sessionId = null;
    private ?string $userData = null;
    private ?string $proxyDsn = null;
    private ?UserAgent $userAgent = null;
    private ?int $hardwareConcurrency = null;
    private ?int $deviceMemory = null;
    private ?string $locale = null;
    private ?string $timezoneId = null;
    private ?DeviceMetrics $deviceMetrics = null;
    private ?WebGl $webGl = null;
    private ?MediaDevices $mediaDevices = null;
    /**
     * @var array<string>|null
     */
    private ?array $fonts = null;
    private ?Preferences $preferences = null;

    public function sessionId(string $sessionId): self
    {
        $this->sessionId = $sessionId;

        return $this;
    }

    public function userData(string $userData): self
    {
        $this->userData = $userData;

        return $this;
    }

    public function proxyDsn(string $proxyDsn): self
    {
        $this->proxyDsn = $proxyDsn;

        return $this;
    }

    public function userAgent(UserAgent $userAgent): self
    {
        $this->userAgent = $userAgent;

        return $this;
    }

    public function hardwareConcurrency(int $hardwareConcurrency): self
    {
        $this->hardwareConcurrency = $hardwareConcurrency;

        return $this;
    }

    public function deviceMemory(int $deviceMemory): self
    {
        $this->deviceMemory = $deviceMemory;

        return $this;
    }

    public function locale(string $locale): self
    {
        $this->locale = $locale;

        return $this;
    }

    public function timezoneId(string $timezoneId): self
    {
        $this->timezoneId = $timezoneId;

        return $this;
    }

    public function deviceMetrics(DeviceMetrics $deviceMetrics): self
    {
        $this->deviceMetrics = $deviceMetrics;

        return $this;
    }

    public function webGl(WebGl $webGl): self
    {
        $this->webGl = $webGl;

        return $this;
    }

    public function mediaDevices(MediaDevices $mediaDevices): self
    {
        $this->mediaDevices = $mediaDevices;

        return $this;
    }

    public function fonts(array $fonts): self
    {
        $this->fonts = $fonts;

        return $this;
    }

    public function preferences(Preferences $preferences): self
    {
        $this->preferences = $preferences;

        return $this;
    }

    public function build(): Profile
    {
        return new Profile(
            $this->sessionId,
            $this->userData,
            $this->proxyDsn,
            $this->userAgent,
            $this->hardwareConcurrency,
            $this->deviceMemory,
            $this->locale,
            $this->timezoneId,
            $this->deviceMetrics,
            $this->webGl,
            $this->mediaDevices,
            $this->fonts,
            $this->preferences,
        );
    }
}
