<?php

namespace Avodel\WebDriver\Components\Debug;

use Avodel\WebDriver\Components\Ajax\AjaxHandler;
use Avodel\WebDriver\Components\Frames\FramesHandler;
use Behat\Mink\Session;
use Psr\Log\LoggerInterface;

final readonly class DebuggerFactory
{
    public function __construct(
        private DebugDumperFactory $debugDumperFactory,
        private LoggerInterface $logger,
    )
    {
    }

    public function create(
        Session $session,
        FramesHandler $framesHandler,
        AjaxHandler $ajaxHandler,
    ): Debugger
    {
        $debugDumper = $this->debugDumperFactory->create();
        $debugDumpFilesPreparer = new DebugDumpFilesPreparer($session, $framesHandler, $ajaxHandler);

        return new Debugger(
            $debugDumper,
            $session,
            $this->logger,
            $debugDumpFilesPreparer,
        );
    }
}
