<?php

namespace Avodel\WebDriver\Components\CaptchaVerifier\Verifier;

use Avodel\WebDriver\Components\CaptchaVerifier\Solver\CloudflareTurnstileTokenSolverInterface;
use Behat\Mink\Session;
use Webmozart\Assert\Assert;

final readonly class CloudflareTurnstileVerifier implements CaptchaVerifierInterface
{
    public function __construct(
        private CloudflareTurnstileTokenSolverInterface $cloudflareTurnstileSolver,
    )
    {
    }

    public function verify(Session $session, array $frames): void
    {
        $siteKey = $session->evaluateScript('window.turnstileSiteKey');
        $token = $this->cloudflareTurnstileSolver->getSolution($session->getCurrentUrl(), $siteKey);

        $verificationJs = <<<JS
window.postMessage({
    type: "invokeTurnstileCallback",
    params: {publicKey: window.turnstileSiteKey, token: '$token'}
}, location.origin)
JS;

        $session->executeScript($verificationJs);

        Assert::true($session->evaluateScript('window.turnstileSolved'), 'Captcha was not solved.');
    }

    public function isVerificationRequired(Session $session, array $frames): bool
    {
        return $session->evaluateScript('window.turnstileSiteKey !== undefined && window.turnstileSolved === false');
    }
}
