<?php

namespace Avodel\WebDriver\Profile;

final readonly class UserAgentMetadata
{
    public function __construct(
        /**
         * @var UserAgentBrandVersion[]
         */
        private array $brands,
        private string $platform,
        private string $platformVersion,
        private string $architecture,
        private string $model,
        private bool $mobile,
    )
    {
    }

    public function getBrands(): array
    {
        return $this->brands;
    }

    public function getPlatform(): string
    {
        return $this->platform;
    }

    public function getPlatformVersion(): string
    {
        return $this->platformVersion;
    }

    public function getArchitecture(): string
    {
        return $this->architecture;
    }

    public function getModel(): string
    {
        return $this->model;
    }

    public function isMobile(): bool
    {
        return $this->mobile;
    }
}
