<?php

namespace Avodel\WebDriver\Components\Ajax;

use Behat\Mink\Session;
use Psr\Clock\ClockInterface;
use Psr\Log\LoggerInterface;
use Symfony\Component\Serializer\SerializerInterface;

final readonly class AjaxHandlerFactory
{
    public function __construct(
        private LoggerInterface $logger,
        private SerializerInterface $serializer,
        private ClockInterface $clock,
        private int $maxWaitingTimeMs
    )
    {
    }

    public function create(Session $session): AjaxHandler
    {
        return new AjaxHandler(
              $session,
              $this->maxWaitingTimeMs,
              $this->logger,
              $this->serializer,
              $this->clock
        );
    }
}
