<?php

namespace Avodel\WebDriver\Profile;

final readonly class FallbackProfileManager implements ProfileManagerInterface
{
    public function getOne(): Profile
    {
        return Profile::builder()
            ->userAgent(
                new UserAgent(
                    'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36',
                    'en-US,en,pl',
                    'Linux x86_64',
                    new UserAgentMetadata(
                        [
                            new UserAgentBrandVersion('Google Chrome', '131'),
                            new UserAgentBrandVersion('Chromium', '131'),
                            new UserAgentBrandVersion('Not_A Brand', '24'),
                        ],
                        'Linux',
                        'X11',
                        'x86_64',
                        'Desktop',
                        false
                    ),
                )
            )
            ->timezoneId('Europe/Warsaw')
            ->deviceMemory(8)
            ->locale('en-US')
            ->hardwareConcurrency(12)
            ->build()
        ;
    }

    public function syncUserData(string $sessionId, string $userData): void
    {
    }
}
