<?php

namespace Avodel\WebDriver\Driver;

use Avodel\ProxyHandler\ProxyHandlerInterface;
use Avodel\WebDriver\Extension\AjaxOverriderWebDriverExtension;
use Avodel\WebDriver\Extension\CloudflareTurnstileWebDriverExtension;
use Avodel\WebDriver\Extension\InitFingerprintWebDriverExtension;
use Avodel\WebDriver\Extension\MouseTrackerExtension;
use Avodel\WebDriver\Mouse\MousePathStrategyInterface;
use Avodel\WebDriver\Profile\ProfileManagerInterface;
use Avodel\WebDriver\UserData\UserDataManager;

final readonly class MinkPhpWebDriverFactory
{
    public function __construct(
        private string $wdHost,
        private ?string $proxyUrl,
        /**
         * @var @var array{script?: int, implicit?: int, page_load?: int}
         */
        private array $timeouts,
        private UserDataManager $userDataManager,
        private ?string $userDataDirectory,
        private ProfileManagerInterface $profileManager,
        private ProxyHandlerInterface $proxyHandler,
        private bool $mouseTrackerEnabled,
        private MousePathStrategyInterface $mousePathStrategy
    )
    {
    }

    public function create(): MinkPhpWebDriver
    {
        $extensions = [
            new InitFingerprintWebDriverExtension(),
            new AjaxOverriderWebDriverExtension(),
            new CloudflareTurnstileWebDriverExtension(),
        ];

        if ($this->mouseTrackerEnabled) {
            $extensions[] = new MouseTrackerExtension();
        }

        return new MinkPhpWebDriver(
            $this->wdHost,
            $extensions,
            $this->proxyUrl,
            $this->timeouts,
            $this->userDataManager,
            $this->userDataDirectory,
            $this->profileManager,
            $this->proxyHandler,
            $this->mousePathStrategy,
        );
    }
}
