(() => {
    "use strict";
    (() => {
        let widgetId;
        const t = Element.prototype.attachShadow;

        Element.prototype.attachShadow = function (...e) {
            e[0] && "closed" === e[0].mode && (e[0].mode = "open");
            return t.apply(this, e)
        };

        (() => {
            const e = setInterval((() => {
                const elements = document.querySelectorAll("*:not([cm-handled])");
                window.elementsCount = elements.length;

                for (const element of elements) {
                    if (element.shadowRoot) {
                        window.foundShadowRoot = true;
                        const iframe = element.shadowRoot.querySelector("iframe");

                        if (iframe && iframe.src.includes("cloudflare")) {
                            clearInterval(e);

                            const substrings = iframe.src.split('/');
                            const turnstileIndex = substrings.indexOf('turnstile');

                            if (turnstileIndex === -1 || turnstileIndex === substrings.length - 1) {
                                return null;
                            }

                            const substringsAfterTurnstile = substrings.slice(turnstileIndex + 1);
                            substringsAfterTurnstile.sort((a, b) => b.length - a.length);

                            window.turnstileSiteKey = substringsAfterTurnstile[0];

                            return;
                        }
                    }
                }
            }))
        })();

        window.addEventListener("message", (t => {
            if ("init" === t.data.event) {
                widgetId = t.data.widgetId;
                window.turnstileSolved = false;
            }
        }));

        window.addEventListener("message", (t => {
            if ("invokeTurnstileCallback" === t.data.type) {
                const token = t.data.params.token;

                if (widgetId) {
                    window.turnstileSolved = true;

                    const t = new MessageEvent("message", {
                        data: {
                            custom: !0,
                            event: "complete",
                            source: "cloudflare-challenge",
                            token: token,
                            widgetId: widgetId
                        }, origin: "https://challenges.cloudflare.com"
                    });
                    window.dispatchEvent(t)
                }
            }
        }))
    })()
})();
