<?php

namespace Avodel\WebDriver\Components\Ajax;

final readonly class AjaxResponse
{
    public function __construct(
        private string $url,
        private int $statusCode,
        private string $content,
        private \DateTimeImmutable $time,
    )
    {
    }

    public function getContent(): string
    {
        return $this->content;
    }

    public function getUrl(): string
    {
        return $this->url;
    }

    public function getStatusCode(): int
    {
        return $this->statusCode;
    }

    public function getTime(): \DateTimeImmutable
    {
        return $this->time;
    }
}
