<?php

namespace Avodel\WebDriver\Components\CaptchaVerifier\Verifier;

use Avodel\WebDriver\Components\CaptchaVerifier\Exception\CaptchaVerificationFailedException;
use Avodel\WebDriver\Components\Frames\Frame;
use Behat\Mink\Session;

interface CaptchaVerifierInterface
{
    /**
     * @throws CaptchaVerificationFailedException
     *
     * @param array<Frame> $frames
     */
    public function verify(Session $session, array $frames): void;

    /**
     * @param array<Frame> $frames
     */
    public function isVerificationRequired(Session $session, array $frames): bool;
}
