(function () {
    document.addEventListener('DOMContentLoaded', () => {
        const cursor = document.createElement('div');
        cursor.style.position = 'absolute';
        cursor.style.zIndex = '10000';
        cursor.style.pointerEvents = 'none';
        cursor.style.width = '24px';
        cursor.style.height = '24px';
        cursor.style.backgroundImage = 'url(data:image/jpeg;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAABLCAMAAAAFzCSKAAAA+VBMVEUAAAD9/f0AAAAAAAANDQ0NDQ0ICAgBAQEBAQEDAwMBAQEDAwMBAQEBAQEbGxsHBwcEBAT9/f37+/sPDw8KCgoDAwMrKyvb29vx8fH4+Pji4uLZ2dnq6uqpqalAQEDo6OilpaVHR0fNzc1sbGzDw8OBgYHu7u7i4uJqamrNzc3j4+P6+vrKysr39/fq6uqLi4uxsbH09PSysrKenp6cnJyVlZUAAAD///8LCwv29vbv7+8XFxfX19fo6OgvLy9VVVUjIyNubm7KyspBQUHg4OBLS0tgYGA5OTmZmZl5eXmioqKrq6u2tra+vr6IiIiQkJCBgYGxsbGPj4+qM1xEAAAANnRSTlMA/QM+DQUSAQIIHjYoFhojUPXtL1pIalPg5My+1Ro8djFipUyPgLmhbbhnz0PDhVqepHppjv5N4Qx0AAADtUlEQVR42r3Xa1faShQG4CbkSkggkXC3ihXFWq329OQ1KKKoCCJezv//MWcP7BpKhJG1urq/8CVPXpLZswc+/b3SNz+ZawHT3Dwtm9Y6yNI3D6tlfQ1j6rZ3iOCrnRg5MfJHQLD1cWPZ7kYDgL+lqeY6JI7hHydGTmq4eOlAEWYNcj4gs7/5IWMyiXrdqbHWIMLglIz5EbI3JdHdbWJkpI7bq4jqJmVkhMwFsMdGRrpERN0Ls81GStj0gSOJIZLbR/cy4rpMGQmRGu5kIp2ERFcT4PAbmVVkJyGJ0cmsJPfRvHlks5TkdxAz4Tp/ZbOK3ES/mzHAA+F9sstk3jywkZG0Uc1lRLmLFutsCARlm42MsPlXEcYy00QTpBe9Y54VHnBp8oNJyjxNjWqmSPaHgkH0rnlJGRkhE8PfYiMlXKOYB2mKXEdyM0/+WUWiazYSsmh4YDNRifgYRatMh9/Bx8mZyOF3zeS7j6eFq256vcH1aPT0PHwYP076MRBwjy4lQ6SK9wKTAP8tpnQARfH9IKhWK5VGo1ar7R1r+jx5ftsnZ7OvP4ay02q12+1ms1miKhacvGFbv8iXAEMWlxNu0LsY9WJhVkWqQkiEu1rVvITQ3HvkmAn8ViEMM9OiDyfnabrFJ5/3pYqHt4kc824bKDjIOBs5qryorGvYurlIxNwHxrOY8z6C71nPNQxDm5Zt69Y8GfPpUmugc8NrDux7mq1zqSqDhEzPvXrpp0KJs5gLVLc1ujMXX8+kglcWxVLj7RgYAccGPXGqiHyu4FGc4QclepsnAK/r1S0q29RZS0hXCHr5YdisgE/O6AnY0vRlBLTYxZBeqhNSzAuvUheHFLOEUAaJXDabc5pVXHDMEMpXikkT93MDOCgVMrS+mrcR7gC8Se87OPJs631SF8LVdNvIO+0q+ucz8wClzDGLpMbCUkXMAZQB74EYeyImTXabJDwSpkVTPdMOMOHmfIWfjjHFd3nrU3MaU0fMe6DHMYsT1qNmdYXg4zbT8uf2QPCNOzghqm24nqHNbWwnrM3vgVN3McbSbepsIfjZKOanj3G0IsZSqbVNc258OoUa/xS46vWB9NOkWtulGAXDs8vr11sFgF8WMUuLY5oNdPodUPmV+u62QUT2OzhzAlFB7aRVKmZ4HMliKnT7k3aRKnSYSGLCFt2+QBWKZeYGkMSE4vJQjKWsq8n/dqi2S02UcZycGF+8aNIYN0vTzpteT0AiuCN42qmy65PVVXUqS3Z9uiX+0L/Q/wHRRyWxaHSlVAAAAABJRU5ErkJggg==)';
        cursor.style.backgroundSize = 'contain';
        cursor.style.backgroundRepeat = 'no-repeat';
        cursor.style.transform = 'translate(0, 0)';

        document.body.appendChild(cursor);

        document.addEventListener('mousemove', function(event) {
            cursor.style.left = event.pageX + 'px';
            cursor.style.top = event.pageY + 'px';
        });
    });
})();