<?php

namespace Avodel\WebDriver\Profile;


final class ProfileBuilder
{
    private ?string $wdUrl = null;
    private ?string $sessionId = null;
    private ?string $userDataDir = null;
    private ?Proxy $proxy = null;
    private ?UserAgent $userAgent = null;
    private ?int $hardwareConcurrency = null;
    private ?int $deviceMemory = null;
    private ?string $locale = null;
    private ?string $timezoneId = null;
    private ?DeviceMetrics $deviceMetrics = null;
    private ?WebGl $webGl = null;
    private ?MediaDevices $mediaDevices = null;
    /**
     * @var array<string>|null
     */
    private ?array $fonts = null;
    private ?Preferences $preferences = null;

    public function wdUrl(string $wdUrl): self
    {
        $this->wdUrl = $wdUrl;

        return $this;
    }

    public function userDataDir(string $userDataDir): self
    {
        $this->userDataDir = $userDataDir;

        return $this;
    }

    public function sessionId(string $sessionId): self
    {
        $this->sessionId = $sessionId;

        return $this;
    }

    public function proxy(Proxy $proxy): self
    {
        $this->proxy = $proxy;

        return $this;
    }

    public function userAgent(UserAgent $userAgent): self
    {
        $this->userAgent = $userAgent;

        return $this;
    }

    public function hardwareConcurrency(int $hardwareConcurrency): self
    {
        $this->hardwareConcurrency = $hardwareConcurrency;

        return $this;
    }

    public function deviceMemory(int $deviceMemory): self
    {
        $this->deviceMemory = $deviceMemory;

        return $this;
    }

    public function locale(string $locale): self
    {
        $this->locale = $locale;

        return $this;
    }

    public function timezoneId(string $timezoneId): self
    {
        $this->timezoneId = $timezoneId;

        return $this;
    }

    public function deviceMetrics(DeviceMetrics $deviceMetrics): self
    {
        $this->deviceMetrics = $deviceMetrics;

        return $this;
    }

    public function webGl(WebGl $webGl): self
    {
        $this->webGl = $webGl;

        return $this;
    }

    public function mediaDevices(MediaDevices $mediaDevices): self
    {
        $this->mediaDevices = $mediaDevices;

        return $this;
    }

    public function fonts(array $fonts): self
    {
        $this->fonts = $fonts;

        return $this;
    }

    public function preferences(Preferences $preferences): self
    {
        $this->preferences = $preferences;

        return $this;
    }

    public function build(): Profile
    {
        return new Profile(
            $this->wdUrl,
            $this->sessionId,
            $this->userDataDir,
            $this->proxy,
            $this->userAgent,
            $this->hardwareConcurrency,
            $this->deviceMemory,
            $this->locale,
            $this->timezoneId,
            $this->deviceMetrics,
            $this->webGl,
            $this->mediaDevices,
            $this->fonts,
            $this->preferences,
        );
    }
}
