<?php

namespace Avodel\WebDriver\DependencyInjection;

use Avodel\WebDriver\Components\CaptchaVerifier\Solver\FallbackCloudflareTurnstileTokenSolver;
use Avodel\WebDriver\Components\CaptchaVerifier\Solver\FallbackHCaptchaSolver;
use Avodel\WebDriver\Components\CaptchaVerifier\Solver\FallbackRecaptchaV2Solver;
use Avodel\WebDriver\Mouse\BasicMousePathStrategy;
use Avodel\WebDriver\Profile\FallbackProfileManager;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('avodel_web_driver');

        // @phpstan-ignore-next-line
        $treeBuilder->getRootNode()
            ->children()
                ->scalarNode('profile_manager')->defaultValue(FallbackProfileManager::class)->end()
                ->booleanNode('auto_accept_cookies')->defaultValue(false)->end()
                ->arrayNode('timeouts')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->scalarNode('implicit')->defaultValue(0)->end()
                        ->scalarNode('page_load')->defaultValue(300_000)->end()
                        ->scalarNode('script')->defaultValue(30_000)->end()
                    ->end()
                ->end()
                ->arrayNode('mouse')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->booleanNode('enable_tracker')->defaultValue(false)->end()
                        ->scalarNode('path_strategy')->defaultValue(BasicMousePathStrategy::class)->end()
                        ->arrayNode('delays')
                            ->children()
                                ->arrayNode('scroll')
                                    ->children()
                                        ->integerNode('min')->defaultValue(20)->end()
                                        ->integerNode('max')->defaultValue(40)->end()
                                    ->end()
                                ->end()
                                ->arrayNode('move')
                                    ->children()
                                        ->integerNode('min')->defaultValue(20)->end()
                                        ->integerNode('max')->defaultValue(25)->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
                ->arrayNode('components')
                    ->children()
                        ->scalarNode('debug')->defaultValue('file:///app/.debug')->end()
                        ->arrayNode('captcha_verifier')
                            ->children()
                                ->arrayNode('solvers')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('hcaptcha')->defaultValue(FallbackHCaptchaSolver::class)->end()
                                        ->scalarNode('recaptcha_v2')->defaultValue(FallbackRecaptchaV2Solver::class)->end()
                                        ->scalarNode('cloudflare_turnstile')->defaultValue(FallbackCloudflareTurnstileTokenSolver::class)->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('ajax')
                            ->children()
                                ->integerNode('max_waiting_time_ms')->defaultValue(80000)->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
