<?php

namespace Avodel\WebDriver\Profile;


final readonly class MediaDevices
{
    public function __construct(
        private int $audioInputs,
        private int $audioOutputs,
        private int $videoInputs,
    )
    {
    }


    public function getAudioInputs(): int
    {
        return $this->audioInputs;
    }

    public function getAudioOutputs(): int
    {
        return $this->audioOutputs;
    }

    public function getVideoInputs(): int
    {
        return $this->videoInputs;
    }
}
