<?php

namespace Avodel\WebDriver\Profile;

final readonly class UserAgent
{
    public function __construct(
        private string $userAgent,
        private string $acceptLanguage,
        private string $platform,
        private UserAgentMetadata $userAgentMetadata
    )
    {
    }

    public function getUserAgent(): string
    {
        return $this->userAgent;
    }

    public function getAcceptLanguage(): string
    {
        return $this->acceptLanguage;
    }

    public function getPlatform(): string
    {
        return $this->platform;
    }

    public function getUserAgentMetadata(): UserAgentMetadata
    {
        return $this->userAgentMetadata;
    }
}
