<?php

namespace Avodel\WebDriver\Components\CaptchaVerifier\Verifier;

use Avodel\WebDriver\Components\CaptchaVerifier\Exception\CaptchaVerificationFailedException;
use Avodel\WebDriver\Components\Frames\FramesHandler;
use Avodel\WebDriver\Driver\Session;

final readonly class CaptchaVerifier
{
    public function __construct(
        private Session $session,
        private FramesHandler $framesHandler,
        /**
         * @var array<CaptchaVerifierInterface>
         */
        private array $captchaVerifiers,
    )
    {
    }

    /**
     * Verifies the not verified captcha on the page.
     *
     * @throws CaptchaVerificationFailedException
     */
    public function verify(): void
    {
        $frames = $this->framesHandler->getFrames();

        foreach ($this->captchaVerifiers as $captchaVerifier) {
            if ($captchaVerifier->isVerificationRequired($this->session, $frames)) {
                $captchaVerifier->verify($this->session, $frames);
                return;
            }
        }
    }

    /**
     * Checks if any captcha is not verified on the page.
     */
    public function isVerificationRequired(): bool
    {
        $frames = $this->framesHandler->getFrames();

        foreach ($this->captchaVerifiers as $captchaVerifier) {
            if ($captchaVerifier->isVerificationRequired($this->session, $frames)) {
                return true;
            }
        }

        return false;
    }
}
