<?php

namespace Avodel\WebDriver\Components\CaptchaVerifier\Verifier;

use Avodel\WebDriver\Components\Ajax\AjaxHandler;
use Avodel\WebDriver\Components\CaptchaVerifier\Solver\CloudflareTurnstileTokenSolverInterface;
use Avodel\WebDriver\Components\CaptchaVerifier\Solver\HCaptchaSolverInterface;
use Avodel\WebDriver\Components\CaptchaVerifier\Solver\RecaptchaV2SolverInterface;
use Avodel\WebDriver\Components\Frames\FramesHandler;
use Avodel\WebDriver\Driver\Session;

final readonly class CaptchaVerifierFactory
{
    public function __construct(
        private ?RecaptchaV2SolverInterface $recaptchaV2Solver,
        private ?HCaptchaSolverInterface $hCaptchaSolver,
        private ?CloudflareTurnstileTokenSolverInterface $cloudflareTurnstileTokenSolver,
    )
    {
    }

    public function create(Session $session, FramesHandler $framesHandler, AjaxHandler $ajaxHandler): CaptchaVerifier
    {
        if ($this->recaptchaV2Solver !== null) {
            $captchaVerifiers[] = new RecaptchaV2CaptchaVerifier($this->recaptchaV2Solver, $framesHandler, $ajaxHandler);
        }

        if ($this->hCaptchaSolver !== null) {
            $captchaVerifiers[] = new HCaptchaCaptchaVerifier($this->hCaptchaSolver, $framesHandler, $ajaxHandler);
        }

        if ($this->cloudflareTurnstileTokenSolver !== null) {
            $captchaVerifiers[] = new CloudflareTurnstileVerifier($this->cloudflareTurnstileTokenSolver);
        }

        return new CaptchaVerifier(
            $session,
            $framesHandler,
            $captchaVerifiers ?? [],
        );
    }
}
