(brands, brandsFullVersionList, uaFullVersion, platformVersion, architecture, platform) => {
    Object.defineProperty(navigator, "userAgentData", {
        value: {
            brands: brands,
            mobile: false,
            platform: platform,
            getHighEntropyValues: async (hints) => {
                hints = [...new Set(["brands", "mobile", "platform", ...hints])];

                const data = {
                    architecture: architecture,
                    bitness: "64",
                    brands: brands,
                    fullVersionList: brandsFullVersionList,
                    mobile: false,
                    model: "",
                    platform: platform,
                    platformVersion: platformVersion,
                    uaFullVersion: uaFullVersion,
                    wow64: false
                };

                return hints.reduce((acc, hint) => {
                    acc[hint] = data[hint];
                    return acc;
                }, {});
            }
        },
        configurable: true
    });
}
