<?php

namespace Avodel\WebDriver\DependencyInjection;

use Avodel\WebDriver\Components\CaptchaVerifier\Solver\CloudflareTurnstileTokenSolverInterface;
use Avodel\WebDriver\Components\CaptchaVerifier\Solver\HCaptchaSolverInterface;
use Avodel\WebDriver\Components\CaptchaVerifier\Solver\RecaptchaV2SolverInterface;
use Avodel\WebDriver\Mouse\MousePathStrategyInterface;
use Avodel\WebDriver\Profile\ProfileManagerInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

class AvodelWebDriverExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yaml');

        $container->setParameter('avodel.web_driver.timeouts', $config['timeouts']);
        $container->setParameter('avodel.web_driver.debug_dump_storage_dsn', $config['components']['debug']);
        $container->setParameter('avodel.web_driver.ajax.max_waiting_time_ms', $config['components']['ajax']['max_waiting_time_ms']);
        $container->setParameter('avodel.web_driver.mouse.tracker_enabled', $config['mouse']['enable_tracker']);
        $container->setParameter('avodel.web_driver.auto_accept_cookies', $config['auto_accept_cookies']);

        $container->setAlias(ProfileManagerInterface::class, $config['profile_manager']);

        $solverClasses = $config['components']['captcha_verifier']['solvers'];

        if (isset($solverClasses['hcaptcha'])) {
            $container->setAlias(HCaptchaSolverInterface::class, $solverClasses['hcaptcha']);
        }

        if (isset($solverClasses['recaptcha_v2'])) {
            $container->setAlias(RecaptchaV2SolverInterface::class, $solverClasses['recaptcha_v2']);
        }

        if (isset($solverClasses['cloudflare_turnstile'])) {
            $container->setAlias(CloudflareTurnstileTokenSolverInterface::class, $solverClasses['cloudflare_turnstile']);
        }

        $container->setAlias(MousePathStrategyInterface::class, $config['mouse']['path_strategy']);
        $container->setParameter('avodel.web_driver.mouse.delays', $config['mouse']['delays']);
    }
}
