<?php

namespace Avodel\WebDriver\Profile;

final readonly class FallbackProfileManager implements ProfileManagerInterface
{
    public function startSession(SessionBag $sessionBag): Profile
    {
        return Profile::builder()
            ->userAgent(
                new UserAgent(
                    'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36',
                    'en-US,en,pl',
                    'Linux x86_64',
                    new UserAgentMetadata(
                        [
                            new UserAgentBrandVersion('Chromium', '131', '134.0.6998.89'),
                            new UserAgentBrandVersion('Not:A-Brand', '24', '24.0.0.0'),
                            new UserAgentBrandVersion('Google Chrome', '131', '134.0.6998.89'),
                        ],
                        'Linux',
                        'X11',
                        'x86_64',
                        'Desktop',
                        false,
                    ),
                    '134.0.6998.89'
                )
            )
            ->timezoneId('Europe/Warsaw')
            ->deviceMemory(8)
            ->locale('en-US')
            ->hardwareConcurrency(12)
            ->build()
        ;
    }

    public function stopSession(SessionBag $sessionBag): void
    {
    }
}
