<?php

namespace Avodel\WebDriver\Profile;


final readonly class Profile
{
    public function __construct(
        private string $wdUrl,
        private ?string $sessionId,
        private ?string $userDataDir,
        private ?Proxy $proxy,
        private ?UserAgent $userAgent,
        private ?int $hardwareConcurrency,
        private ?int $deviceMemory,
        private ?string $locale,
        private ?string $timezoneId,
        private ?DeviceMetrics $deviceMetrics,
        private ?WebGl $webGl,
        private ?MediaDevices $mediaDevices,
        /**
         * @var array<string>|null
         */
        private ?array $fonts,
        private ?Preferences $preferences,
    )
    {
    }

    public function getWdUrl(): string
    {
        return $this->wdUrl;
    }

    public function getUserDataDir(): ?string
    {
        return $this->userDataDir;
    }

    public function getSessionId(): ?string
    {
        return $this->sessionId;
    }

    public function getProxy(): ?Proxy
    {
        return $this->proxy;
    }

    public function getUserAgent(): ?UserAgent
    {
        return $this->userAgent;
    }

    public function getHardwareConcurrency(): ?int
    {
        return $this->hardwareConcurrency;
    }

    public function getLocale(): ?string
    {
        return $this->locale;
    }

    public function getTimezoneId(): ?string
    {
        return $this->timezoneId;
    }

    public function getDeviceMetrics(): ?DeviceMetrics
    {
        return $this->deviceMetrics;
    }

    public function getWebGl(): ?WebGl
    {
        return $this->webGl;
    }

    public function getDeviceMemory(): ?int
    {
        return $this->deviceMemory;
    }

    public function getMediaDevices(): ?MediaDevices
    {
        return $this->mediaDevices;
    }

    public function getFonts(): array|null
    {
        return $this->fonts;
    }

    public function getPreferences(): ?Preferences
    {
        return $this->preferences;
    }

    public static function builder(): ProfileBuilder
    {
        return new ProfileBuilder();
    }
}
