<?php

declare(strict_types=1);

namespace Avodel\WebDriver\Components\Debug;

readonly class LocalDebugDumper implements DebugDumperInterface
{
    private string $basePath;

    public function __construct(
        string $basePath
    ) {
        $this->basePath = rtrim($basePath, '/');
    }

    public function save(DebugDumpFilesPreparer $debugDumpFilesPreparer, DumpOpts $dumpOpts): string
    {
        $dumpPath = $this->basePath . '/' . $dumpOpts->getDumpName();

        $debugDumpFilesPreparer->prepareDump($dumpPath, $dumpOpts->isDumpAssets());

        return $dumpPath;
    }
}