<?php

namespace Avodel\WebDriver\Driver;

use Avodel\WebDriver\Extension\AjaxOverriderWebDriverExtension;
use Avodel\WebDriver\Extension\CloudflareTurnstileWebDriverExtension;
use Avodel\WebDriver\Extension\InitFingerprintWebDriverExtension;
use Avodel\WebDriver\Extension\MouseTrackerExtension;
use Avodel\WebDriver\Mouse\MousePathStrategyInterface;
use Avodel\WebDriver\Profile\ProfileManagerInterface;

final readonly class MinkPhpWebDriverFactory
{
    public function __construct(
        /**
         * @var @var array{script?: int, implicit?: int, page_load?: int}
         */
        private array $timeouts,
        private ProfileManagerInterface $profileManager,
        private bool $mouseTrackerEnabled,
        private MousePathStrategyInterface $mousePathStrategy,
        private bool $autoAcceptCookies,
        /**
         * @var array{scroll: array{min: int, max: int}, move: array{min: int, max: int}}
         */
        private array $mouseDelays,
    )
    {
    }

    public function create(): MinkPhpWebDriver
    {
        $extensions = [
            new InitFingerprintWebDriverExtension(),
            new AjaxOverriderWebDriverExtension(),
            new CloudflareTurnstileWebDriverExtension(),
        ];

        if ($this->mouseTrackerEnabled) {
            $extensions[] = new MouseTrackerExtension();
        }

        return new MinkPhpWebDriver(
            $extensions,
            $this->timeouts,
            $this->profileManager,
            $this->mousePathStrategy,
            $this->autoAcceptCookies,
            $this->mouseDelays,
        );
    }
}
