(hardwareConcurrency, deviceMemory, platform, webGLVendor, webGLRenderer) => {
    const originalBlob = window.Blob;

    const injectedCode = `
    if (${hardwareConcurrency}) {
        Object.defineProperty(navigator, 'hardwareConcurrency', {
          get: () => ${hardwareConcurrency}
        });
    }
    
    if ('${platform}') {
        Object.defineProperty(navigator, 'platform', {
          get: () => '${platform}'
        });
    }
    
    if (${deviceMemory}) {
        Object.defineProperty(navigator, 'deviceMemory', {
          get: () => ${deviceMemory}
        });
    }
    
    if ('${webGLVendor}' && '${webGLRenderer}') {
        ((vendor, renderer) => {
            const originalFunctionToString = Function.prototype.toString;
        
            const nativeToString = 'function getParameter() { [native code] }';
        
            const getParameterProxyHandler = {
                apply: function (target, ctx, args) {
                    const param = (args || [])[0];
                    if (param === 37445) return vendor; // UNMASKED_VENDOR_WEBGL
                    if (param === 37446) return renderer; // UNMASKED_RENDERER_WEBGL
                    return Reflect.apply(target, ctx, args);
                },
            };
        
            const patchMethod = (prototype, methodName) => {
                const original = prototype[methodName];
                const proxy = new Proxy(original, getParameterProxyHandler);
        
                proxy.toString = function () {
                    return nativeToString;
                };
        
                Object.defineProperty(prototype, methodName, {
                    value: proxy,
                    configurable: true,
                    enumerable: false,
                    writable: true,
                });
            };
        
            patchMethod(WebGLRenderingContext.prototype, 'getParameter');
            patchMethod(WebGL2RenderingContext.prototype, 'getParameter');
        
            Function.prototype.toString = function () {
                if (this.toString === originalFunctionToString) {
                    return originalFunctionToString.call(this);
                }
                if (this.name === 'getParameter' && this.toString() === nativeToString) {
                    return nativeToString;
                }
                return originalFunctionToString.call(this);
            };
        }
        )('${webGLVendor}', '${webGLRenderer}');
    }
   
    
  `.trim();

    const encodedInjectedCode = injectedCode.replace(/\\/g, '\\\\').replace(/`/g, '\\`').replace(/\$/g, '\\$');

    window.Blob = function (parts, options) {
        const shouldInject = Array.isArray(parts) && parts.some(p => typeof p === 'string' && p.includes('self.postMessage'));

        if (shouldInject) {
            try {
                const newParts = parts.map(part => {
                    if (typeof part === 'string') {
                        return `${encodedInjectedCode}\n${part}`;
                    }
                    return part;
                });
                return new originalBlob(newParts, options);
            } catch (e) {
                console.warn('Blob injection failed', e);
                return new originalBlob(parts, options);
            }
        }

        return new originalBlob(parts, options);
    };

    window.Blob.prototype = originalBlob.prototype;
    window.Blob.toString = () => 'function Blob() { [native code] }';
}
