<?php

namespace Avodel\WebDriver\Profile;

final readonly class WebGl
{
    public function __construct(
        private string $vendor,
        private string $renderer,
        private string $brand,
        private ?string $architecture,
    )
    {
    }

    public function getRenderer(): string
    {
        return $this->renderer;
    }

    public function getVendor(): string
    {
        return $this->vendor;
    }

    public function getBrand(): string
    {
        return $this->brand;
    }

    public function getArchitecture(): ?string
    {
        return $this->architecture;
    }
}
