(webGLRenderer) => {
    const hash = [...webGLRenderer].reduce((acc, char) => acc + char.charCodeAt(0), 0);
    const noise = hash % 17;

    const originalToDataURL = HTMLCanvasElement.prototype.toDataURL;
    HTMLCanvasElement.prototype.toDataURL = function(...args) {
        const ctx = this.getContext('2d');
        const imgData = ctx.getImageData(0, 0, this.width, this.height);
        for (let i = 0; i < imgData.data.length; i += 4) {
            imgData.data[i]     ^= noise;
            imgData.data[i + 1] ^= noise;
            imgData.data[i + 2] ^= noise;
        }
        ctx.putImageData(imgData, 0, 0);
        return originalToDataURL.apply(this, args);
    };

    const originalFunctionToString = Function.prototype.toString;
    const toDataURLSource = originalFunctionToString.call(originalToDataURL);

    Function.prototype.toString = new Proxy(originalFunctionToString, {
        apply(target, thisArg, args) {
            if (thisArg === HTMLCanvasElement.prototype.toDataURL) {
                return toDataURLSource;
            }
            return Reflect.apply(target, thisArg, args);
        }
    });
}
