(vendor, architecture) => {
    Object.defineProperty(navigator, 'gpu', {
        value: {
            requestAdapter: async () => {
                return {
                    name: undefined,
                    isSoftware: false,
                    features: new Set(['float32-blendable', 'depth32float-stencil8', 'rg11b10ufloat-renderable', 'bgra8unorm-storage', 'texture-compression-astc', 'texture-compression-etc2', 'depth-clip-control', 'texture-compression-bc', 'dual-source-blending', 'timestamp-query', 'clip-distances', 'shader-f16', 'float32-filterable', 'indirect-first-instance', 'subgroups']),
                    limits: {
                        maxBindGroups: 4,
                        maxBindGroupsPlusVertexBuffers: 24,
                        maxBindingsPerBindGroup: 1000,
                        maxBufferSize: 4294967296,
                        maxColorAttachmentBytesPerSample: 128,
                        maxColorAttachments: 8,
                        maxComputeInvocationsPerWorkgroup: 1024,
                        maxComputeWorkgroupSizeX: 1024,
                        maxComputeWorkgroupSizeY: 1024,
                        maxComputeWorkgroupSizeZ: 64,
                        maxComputeWorkgroupStorageSize: 32768,
                        maxComputeWorkgroupsPerDimension: 65535,
                        maxDynamicStorageBuffersPerPipelineLayout: 8,
                        maxDynamicUniformBuffersPerPipelineLayout: 10,
                        maxInterStageShaderVariables: 28,
                        maxSampledTexturesPerShaderStage: 16,
                        maxSamplersPerShaderStage: 16,
                        maxStorageBufferBindingSize: 4294967292,
                        maxStorageBuffersPerShaderStage: 10,
                        maxStorageTexturesPerShaderStage: 8,
                        maxTextureArrayLayers: 2048,
                        maxTextureDimension1D: 16384,
                        maxTextureDimension2D: 16384,
                        maxTextureDimension3D: 2048,
                        maxUniformBufferBindingSize: 65536,
                        maxUniformBuffersPerShaderStage: 12,
                        maxVertexAttributes: 30,
                        maxVertexBufferArrayStride: 2048,
                        maxVertexBuffers: 8,
                        minStorageBufferOffsetAlignment: 256,
                        minUniformBufferOffsetAlignment: 256,
                    },
                    info: {
                        vendor: vendor,
                        architecture: architecture,
                        device: '',
                        description: '',
                    }
                };
            }
        },
        configurable: true
    });
}
