(vendor, renderer) => {
    const originalFunctionToString = Function.prototype.toString;

    const nativeToString = 'function getParameter() { [native code] }';

    const getParameterProxyHandler = {
        apply: function (target, ctx, args) {
            const param = (args || [])[0];
            if (param === 37445) return vendor; // UNMASKED_VENDOR_WEBGL
            if (param === 37446) return renderer; // UNMASKED_RENDERER_WEBGL
            return Reflect.apply(target, ctx, args);
        },
    };

    const patchMethod = (prototype, methodName) => {
        const original = prototype[methodName];
        const proxy = new Proxy(original, getParameterProxyHandler);

        proxy.toString = function () {
            return nativeToString;
        };

        Object.defineProperty(prototype, methodName, {
            value: proxy,
            configurable: true,
            enumerable: false,
            writable: true,
        });
    };

    patchMethod(WebGLRenderingContext.prototype, 'getParameter');
    patchMethod(WebGL2RenderingContext.prototype, 'getParameter');

    Function.prototype.toString = function () {
        if (this.toString === originalFunctionToString) {
            return originalFunctionToString.call(this);
        }
        if (this.name === 'getParameter' && this.toString() === nativeToString) {
            return nativeToString;
        }
        return originalFunctionToString.call(this);
    };
}


