<?php

namespace Avodel\WebDriver\Components\Frames;

final readonly class Frame
{
    public function __construct(
        private array $path,
        private string $id,
        private string $name,
        private string $src
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getSrc(): string
    {
        return $this->src;
    }

    public function getPath(): array
    {
        return $this->path;
    }
}
