<?php

namespace Avodel\WebDriver\Driver;

use Avodel\WebDriver\Extension\AjaxOverriderWebDriverExtension;
use Avodel\WebDriver\Extension\CloudflareTurnstileWebDriverExtension;
use Avodel\WebDriver\Extension\InitFingerprintWebDriverExtension;
use Avodel\WebDriver\Extension\MouseTrackerExtension;
use Avodel\WebDriver\Extension\WebDriverExtensionInterface;
use Avodel\WebDriver\Keyboard\TypingAccuracyConfig;
use Avodel\WebDriver\Keyboard\DelayRange;
use Avodel\WebDriver\Mouse\MousePathStrategyInterface;
use Avodel\WebDriver\Profile\ProfileManagerInterface;

final readonly class MinkPhpWebDriverFactory
{
    public function __construct(
        /**
         * @var @var array{script?: int, implicit?: int, page_load?: int}
         */
        private array $timeouts,
        private ProfileManagerInterface $profileManager,
        private bool $mouseTrackerEnabled,
        private MousePathStrategyInterface $mousePathStrategy,
        private bool $autoAcceptCookies,
        /**
         * @var array{
         *     accuracy: float,
         *     on_typo_delay: array{min: int, max: int},
         *     backspace_delay: array{min: int, max: int},
         *     after_typo_fixed_delay: array{min: int, max: int}
         * }
         */
        private array $typingAccuracyConfig,
        /**
         * @var array<WebDriverExtensionInterface>
         */
        private array $extensions,
    ) {
    }

    public function create(): MinkPhpWebDriver
    {
        $extensions = [
            new InitFingerprintWebDriverExtension(),
            new AjaxOverriderWebDriverExtension(),
            new CloudflareTurnstileWebDriverExtension(),
        ];

        if ($this->mouseTrackerEnabled) {
            $extensions[] = new MouseTrackerExtension();
        }

        array_push($extensions, ...$this->extensions);

        $typingAccuracyConfig = new TypingAccuracyConfig(
            $this->typingAccuracyConfig['accuracy'],
            new DelayRange($this->typingAccuracyConfig['on_typo_delay']['min'], $this->typingAccuracyConfig['on_typo_delay']['max']),
            new DelayRange($this->typingAccuracyConfig['backspace_delay']['min'], $this->typingAccuracyConfig['backspace_delay']['max']),
            new DelayRange($this->typingAccuracyConfig['after_typo_fixed_delay']['min'], $this->typingAccuracyConfig['after_typo_fixed_delay']['max'])
        );

        return new MinkPhpWebDriver(
            $extensions,
            $this->timeouts,
            $this->profileManager,
            $this->mousePathStrategy,
            $this->autoAcceptCookies,
            $typingAccuracyConfig
        );
    }
}
