<?php

namespace Avodel\WebDriver\Driver;

use Avodel\WebDriver\Profile\Proxy;
use Behat\Mink\Element\DocumentElement;
use Behat\Mink\Element\NodeElement;
use Behat\Mink\Session as MinkSession;
use Facebook\WebDriver\Chrome\ChromeDevToolsDriver;
use Facebook\WebDriver\WebDriverBy;

final readonly class Session
{
    public function __construct(
        private MinkSession $minkSession,
        private MinkPhpWebDriver $minkPhpWebDriver,
        private CookiesBag $cookiesBag,
    ) {
    }

    public function isStarted(): bool
    {
        return $this->minkSession->isStarted();
    }

    public function start(): void
    {
        $this->minkSession->start();
    }

    public function stop(): void
    {
        $this->minkSession->stop();
    }

    public function reset(): void
    {
        $this->minkSession->reset();
    }

    public function getPage(): DocumentElement
    {
        return $this->minkSession->getPage();
    }

    public function visit(string $url): void
    {
        $this->minkSession->visit($url);
    }

    public function getCurrentUrl(): string
    {
        return $this->minkSession->getCurrentUrl();
    }

    public function getScreenshot(): string
    {
        return $this->minkSession->getScreenshot();
    }

    public function reload(): void
    {
        $this->minkSession->reload();
    }

    public function switchToIFrame(?string $name = null): void
    {
        $this->minkSession->switchToIFrame($name);
    }

    public function executeScript(string $script): void
    {
        $this->minkSession->executeScript($script);
    }

    public function evaluateScript(string $script): mixed
    {
        return $this->minkSession->evaluateScript($script);
    }

    public function wait(int $time, string $condition = 'false'): bool
    {
        return $this->minkSession->wait($time, $condition);
    }

    public function printToPdf(): string
    {
        $coreDriver = $this->minkPhpWebDriver->getWebDriver();
        $chromeDevToolsDriver = new ChromeDevToolsDriver($coreDriver);
        $encodedPdf = $chromeDevToolsDriver->execute('Page.printToPDF');

        return $encodedPdf['data'];
    }

    public function scrollToElement(NodeElement $element): void
    {
        $webDriverElement = $this->minkPhpWebDriver->getWebDriver()->findElement(WebDriverBy::xpath($element->getXpath()));
        $this->minkPhpWebDriver->scrollElementIntoViewIfRequired($webDriverElement);
    }

    public function getProxy(): ?Proxy
    {
       return $this->minkPhpWebDriver->getProxy();
    }

    public function getBrowserLogs(): array
    {
        return $this->minkPhpWebDriver->getWebDriver()->manage()->getLog('browser');
    }

    public function getCookiesBag(): CookiesBag
    {
        return $this->cookiesBag;
    }
}
