<?php

namespace Avodel\WebDriver\Profile;

final readonly class FallbackProfileManager implements ProfileManagerInterface
{
    public function startSession(SessionBag $sessionBag): Profile
    {
        return Profile::builder()
            ->userAgent(
                new UserAgent(
                    'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36',
                    'en-US,en,pl',
                    'MacIntel',
                    new UserAgentMetadata(
                        [
                            new UserAgentBrandVersion('Google Chrome', '134', '134.0.0.0'),
                            new UserAgentBrandVersion('Chromium', '134', '134.0.0.0'),
                            new UserAgentBrandVersion('Not.A Brand', '99', '99.0.0.0'),
                        ],
                        'macOS',
                        'MacIntel',
                        'arm',
                    ),
                    '134.0.0.0',
                ),
            )
            ->timezoneId('Europe/Warsaw')
            ->locale('en-US')
            ->baseTypingCpm(500)
            ->build()
        ;
    }

    public function stopSession(SessionBag $sessionBag): void
    {
    }
}
