<?php

namespace Avodel\WebDriver\Profile;


final class ProfileBuilder
{
    private ?string $wdUrl = null;
    private ?string $sessionId = null;
    private ?string $userDataDir = null;
    private ?Proxy $proxy = null;
    private ?UserAgent $userAgent = null;
    private ?string $locale = null;
    private ?string $timezoneId = null;
    private ?DeviceMetrics $deviceMetrics = null;
    private ?Preferences $preferences = null;
    private ?int $baseTypingCpm = null;

    public function wdUrl(string $wdUrl): self
    {
        $this->wdUrl = $wdUrl;

        return $this;
    }

    public function userDataDir(string $userDataDir): self
    {
        $this->userDataDir = $userDataDir;

        return $this;
    }

    public function sessionId(string $sessionId): self
    {
        $this->sessionId = $sessionId;

        return $this;
    }

    public function proxy(Proxy $proxy): self
    {
        $this->proxy = $proxy;

        return $this;
    }

    public function userAgent(UserAgent $userAgent): self
    {
        $this->userAgent = $userAgent;

        return $this;
    }

    public function locale(string $locale): self
    {
        $this->locale = $locale;

        return $this;
    }

    public function timezoneId(string $timezoneId): self
    {
        $this->timezoneId = $timezoneId;

        return $this;
    }

    public function deviceMetrics(DeviceMetrics $deviceMetrics): self
    {
        $this->deviceMetrics = $deviceMetrics;

        return $this;
    }

    public function preferences(Preferences $preferences): self
    {
        $this->preferences = $preferences;

        return $this;
    }

    public function baseTypingCpm(int $baseCpm): self
    {
        $this->baseTypingCpm = $baseCpm;

        return $this;
    }


    public function build(): Profile
    {
        return new Profile(
            $this->wdUrl,
            $this->baseTypingCpm,
            $this->sessionId,
            $this->userDataDir,
            $this->proxy,
            $this->userAgent,
            $this->locale,
            $this->timezoneId,
            $this->deviceMetrics,
            $this->preferences,
        );
    }
}
