(() => {
    Object.defineProperty(window, "navigator", {
        value: new Proxy(navigator, {
            has: (target, key) => (key === "platform" ? true : key in target),
            get: (target, key) =>
                key === "platform"
                    ? "Linux x86_64"
                    : typeof target[key] === "function"
                        ? target[key].bind(target)
                        : target[key],
        }),
    });
})();
