<?php

namespace Avodel\WebDriver\Driver;

use Facebook\WebDriver\Chrome\ChromeDevToolsDriver;
use Facebook\WebDriver\Cookie;

final readonly class CookiesBag
{
    public function __construct(
        private MinkPhpWebDriver $minkPhpWebDriver,
    )
    {
    }

    /**
     * @return Cookie[]
     */
    public function all(): array
    {
        $devTools = new ChromeDevToolsDriver($this->minkPhpWebDriver->getWebDriver());

        $result = $devTools->execute('Network.getCookies');
        $cookieArrays = $result['cookies'] ?? [];

        foreach ($cookieArrays as $cookieArray) {
            $cookies[] = Cookie::createFromArray($cookieArray);
        }

        return $cookies ?? [];
    }

    public function clear(): void
    {
        $devTools = new ChromeDevToolsDriver($this->minkPhpWebDriver->getWebDriver());
        $devTools->execute('Network.clearBrowserCookies');
    }
}
