<?php

namespace Avodel\WebDriver\Components\CaptchaVerifier\Solver;

readonly class RecaptchaV2Challenge
{
    public function __construct(
        private string $url,
        private string $siteKey,
        private ?string $userAgent,
        private ?string $dataS,
        /**
         * Represents a list of cookies as ['name'=>'value'] pairs.
         *
         * @var array<string, string>
         */
        private array $cookies
    ) {
    }

    public function getUrl(): string
    {
        return $this->url;
    }

    public function getSiteKey(): string
    {
        return $this->siteKey;
    }

    public function getUserAgent(): string
    {
        return $this->userAgent;
    }

    public function getDataS(): ?string
    {
        return $this->dataS;
    }

    /**
     * @return array<string, string>
     */
    public function getCookies(): array
    {
        return $this->cookies;
    }
}