<?php

namespace Avodel\WebDriver\Components\Debug;

use Avodel\WebDriver\Driver\Session;
use Psr\Log\LoggerInterface;

final readonly class Debugger
{
    public function __construct(
        private DebugDumperInterface $debugDumper,
        private Session $session,
        private LoggerInterface $logger,
        private DebugDumpFilesPreparer $debugDumpFilesPreparer
    )
    {
    }

    /**
     * Dumps the page state including the content, frames, ajax responses and screenshots to configured storage.
     */
    public function dump(bool $dumpAssets = false): array
    {
        if (!$this->session->isStarted()) {
            return [
                'isSessionStarted' => false,
            ];
        }

        $dumpName = 'dump_' . ((int) round(microtime(true) * 1000));

        $dumpOpts = new DumpOpts($dumpName, $dumpAssets);

        try {
            $dumpPath = $this->debugDumper->save($this->debugDumpFilesPreparer, $dumpOpts);
        } catch (\Throwable $e) {
            $this->logger->warning('Unable to save dump.', ['exception' => $e]);
        }

        return [
            'url' => $this->session->getCurrentUrl(),
            'dump' => $dumpPath ?? '-',
        ];
    }
}
