<?php

namespace Avodel\WebDriver\Keyboard;

readonly class TypingAccuracyConfig
{
    public function __construct(
        private float $accuracy,
        private DelayRange $onTypoDelay,
        private DelayRange $backspaceDelay,
        private DelayRange $afterTypoFixedDelay,
    ) {
    }

    public function getAccuracy(): float
    {
        return $this->accuracy;
    }

    public function getOnTypoDelay(): DelayRange
    {
        return $this->onTypoDelay;
    }

    public function getBackspaceDelay(): DelayRange
    {
        return $this->backspaceDelay;
    }

    public function getAfterTypoFixedDelay(): DelayRange
    {
        return $this->afterTypoFixedDelay;
    }
}