<?php

declare(strict_types=1);

namespace Avodel\WebDriver\Mouse;

class BasicMousePathStrategy implements MousePathStrategyInterface
{
    public function calculatePath(Coordinate $from, Coordinate $to): array
    {
        $fromX = $from->getX();
        $fromY = $from->getY();
        $toX = $to->getX();
        $toY = $to->getY();

        $control1 = [
            $fromX + rand(30, 120),
            $fromY - rand(30, 120)
        ];
        $control2 = [
            $toX - rand(30, 120),
            $toY + rand(30, 120)
        ];

        $distance = sqrt(pow($toX - $fromX, 2) + pow($toY - $fromY, 2));
        $steps = max(10, (int) $distance / 10);

        $steps += rand(-5, 15);

        $coordinates = [];

        for ($i = 0; $i <= $steps; $i++) {
            $t = $i / $steps;
            $easeT = $t < 0.5 ? 2 * $t * $t : 1 - pow(-2 * $t + 2, 2) / 2;

            $x = pow(1 - $easeT, 3) * $fromX +
                3 * pow(1 - $easeT, 2) * $easeT * $control1[0] +
                3 * (1 - $easeT) * pow($easeT, 2) * $control2[0] +
                pow($easeT, 3) * $toX;

            $y = pow(1 - $easeT, 3) * $fromY +
                3 * pow(1 - $easeT, 2) * $easeT * $control1[1] +
                3 * (1 - $easeT) * pow($easeT, 2) * $control2[1] +
                pow($easeT, 3) * $toY;

            $coordinates[] = new Coordinate($x, $y);
        }

        for ($j = 0; $j < rand(1, 3); $j++) {
            $coordinates[] = new Coordinate($toX + rand(-3, 3), $toY + rand(-3, 3));
        }

        return $coordinates;
    }
}