<?php

namespace Avodel\WebDriver\Profile;

final readonly class DeviceMetrics
{
    public function __construct(
        private int $width,
        private int $height,
        private float $deviceScaleFactor,
        private bool $mobile,
    )
    {
    }

    public function getWidth(): int
    {
        return $this->width;
    }

    public function getHeight(): int
    {
        return $this->height;
    }

    public function getDeviceScaleFactor(): float
    {
        return $this->deviceScaleFactor;
    }

    public function isMobile(): bool
    {
        return $this->mobile;
    }
}
