<?php

namespace Avodel\WebDriver\Profile;

final readonly class Preferences
{
    public function __construct(
        private bool $disableImages,
        private bool $disableNotifications,
        private bool $disablePopups,
        private bool $darkMode
    )
    {
    }

    public function isDisableImages(): bool
    {
        return $this->disableImages;
    }

    public function isDisableNotifications(): bool
    {
        return $this->disableNotifications;
    }

    public function isDisablePopups(): bool
    {
        return $this->disablePopups;
    }

    public function isDarkMode(): bool
    {
        return $this->darkMode;
    }
}
